unit unicmain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Menus, ComCtrls;

type
  TFormMain = class(TForm)
    TabControl1: TTabControl;
    Bevel1: TBevel;
    Lbl1: TLabel;
    Lbl2: TLabel;
    Lbl4: TLabel;
    Lbl5: TLabel;
    Lbl6: TLabel;
    Lbl7: TLabel;
    Lbl8: TLabel;
    Lbl3: TLabel;
    EdAmount: TEdit;
    BtnConvert: TButton;
    RGUnitNames: TRadioGroup;
    RGDecimals: TRadioGroup;
    MainMenu1: TMainMenu;
    MenuFile: TMenuItem;
    File2Decimals: TMenuItem;
    File4Decimals: TMenuItem;
    FileSeparator1: TMenuItem;
    FileExit: TMenuItem;
    MenuConversion: TMenuItem;
    ConvLength: TMenuItem;
    ConvVolume: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure BtnConvertClick(Sender: TObject);
    procedure File2DecimalsClick(Sender: TObject);
    procedure ConvLengthClick(Sender: TObject);
    procedure EdAmountKeyPress(Sender: TObject; var Key: Char);
    procedure FileExitClick(Sender: TObject);
  private
    { Private declarations }
    procedure UnitsConvert;
    procedure ConvertShow;
    procedure SetLabelInvisible;
    function MakeString(MFactor: real; LabelNr: integer): string;
  public
    { Public declarations }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

const
  // Multiplication factors
  // 1 Unit_of_some_kind = X Base Units

  // Length: base unit = METER
  // In 1963, it was decreed that: The yard shall be 0.9144 m "exactly"
  // 1 foot = 12 inch
  // 1 yard = 3 ft
  // 1 mile = 1760 yards = 1609.344 m
  mfMM   = 0.001;    // 1 millimeter = 0.001 m
  mfCM   = 0.01;     // centimeter
  mfM    = 1;        // meter, the Base Unit
  mfKM   = 1000;     // kilometer
  mfInch = 0.0254;
  mfFoot = 0.3048;
  mfYard = 0.9144;
  mfMile = 1609.344;

  // Volume: base unit = CUBIC METER (m3)
  // Inch3, Foot3 and Yard3 are derived directly
  // from the lenght units definitions.
  // In the 1970's, it was decreed that:
  // 1 Gallon UK = 4.54609 Liter "exactly"
  // 1 Gallon US = 3.785411784 Liter "exactly"
  mfCC      = 0.000001;       // 1 cc = 0.000001 m3
  mfLiter   = 0.001;
  mfM3      = 1;              // cubic meter, the Base Unit
  mfInch3   = 0.000016387064;
  mfFoot3   = 0.028316846592;
  mfYard3   = 0.764554857984;
  mfGalUK   = 0.00454609;
  mfGalUS   = 0.003785411784;

var
  BU: Real; // global variable "Base Units"

procedure TFormMain.FormCreate(Sender: TObject);
begin
  RGUnitNames.ItemIndex := 2;  // preset radiogroup to "meter"
  // At start of program, do the first (automatic) conversion
  UnitsConvert;
end;

{ Event handler common to BtnConvert and RGUnitNames }
procedure TFormMain.BtnConvertClick(Sender: TObject);
begin
  UnitsConvert;
end;

{ Convert contents of Edit box to "base units".
  Convert to other units.
  Show results in LABELs.                       }
procedure TFormMain.UnitsConvert;
var
  Amount,            // amount to convert
  MFactor: real;     // multiplication factor
begin
  try
    Amount := StrToFloat(EdAmount.Text);
    case TabControl1.TabIndex of
      // tab 0:  length conversion
      // tab 1:  volume conversion
      0: case RGUnitNames.ItemIndex of
           0 : MFactor := mfMM;
           1 : MFactor := mfCM;
           2 : MFactor := mfM;
           3 : MFactor := mfKM;
           4 : MFactor := mfInch;
           5 : MFactor := mfFoot;
           6 : MFactor := mfYard;
           7 : MFactor := mfMile;
         end;
      1: case RGUnitNames.ItemIndex of
           0 : MFactor := mfCC;
           1 : MFactor := mfLiter;
           2 : MFactor := mfM3;
           3 : MFactor := mfInch3;
           4 : MFactor := mfGalUS;
           5 : MFactor := mfGalUK;
           6 : MFactor := mfFoot3;
           7 : MFactor := mfYard3;
         end;
    end;
    BU := Amount * MFactor;
    ConvertShow;
    SetLabelInvisible;
  except
    on EConvertError do
      MessageDlg('Illegal input!', mtWarning, [mbOk], 0);
  end;
end;

{ Make strings of the conversions to other units.
  Show results in LABELS                         }
procedure TFormMain.ConvertShow;
begin
  if (TabControl1.TabIndex = 0) then begin
    Lbl1.Caption := MakeString(mfMM,   0);
    Lbl2.Caption := MakeString(mfCM,   1);
    Lbl3.Caption := MakeString(mfM,    2);
    Lbl4.Caption := MakeString(mfKM,   3);
    Lbl5.Caption := MakeString(mfInch, 4);
    Lbl6.Caption := MakeString(mfFoot, 5);
    Lbl7.Caption := MakeString(mfYard, 6);
    Lbl8.Caption := MakeString(mfMile, 7);
  end
  else begin
    Lbl1.Caption := MakeString(mfCC,    0);
    Lbl2.Caption := MakeString(mfLiter, 1);
    Lbl3.Caption := MakeString(mfM3,    2);
    Lbl4.Caption := MakeString(mfInch3, 3);
    Lbl5.Caption := MakeString(mfGalUS, 4);
    Lbl6.Caption := MakeString(mfGalUK, 5);
    Lbl7.Caption := MakeString(mfFoot3, 6);
    Lbl8.Caption := MakeString(mfYard3, 7);
  end;
end;

{ Make a string of the value in "other units" (BU / MFactor).
  Pad left with spaces, to a length of 15.
  Get the unitname (mm, cm, m...) out of radiogroup RGUnitNames.
  Return: value + ' ' + unitname.                               }
function TFormMain.MakeString(MFactor: real; LabelNr: integer): string;
var
  Other_Units, FormatStr, UnitName: string;
begin
  if RGDecimals.ItemIndex = 0 then
    FormatStr := '0.00'
  else
    FormatStr := '0.0000';

  Other_Units := FormatFloat(FormatStr, BU / MFactor);
  // Pad left with spaces, to length 15
  Other_Units := Format('%15s%', [Other_Units]);
  // Make the unitname equal to the selected Radiogroup item
  UnitName := RGUnitNames.Items[LabelNr];
  // Return this tring:
  MakeString := Other_Units + ' ' + UnitName;
end;

{ Hide the LABEL next to the selected RADIOBUTTON.
  Make other LABELs visible                       }
procedure TFormMain.SetLabelInvisible;
begin
  Lbl1.Visible := (RGUnitNames.ItemIndex <> 0);
  Lbl2.Visible := (RGUnitNames.ItemIndex <> 1);
  Lbl3.Visible := (RGUnitNames.ItemIndex <> 2);
  Lbl4.Visible := (RGUnitNames.ItemIndex <> 3);
  Lbl5.Visible := (RGUnitNames.ItemIndex <> 4);
  Lbl6.Visible := (RGUnitNames.ItemIndex <> 5);
  Lbl7.Visible := (RGUnitNames.ItemIndex <> 6);
  Lbl8.Visible := (RGUnitNames.ItemIndex <> 7);
end;

{ Event handler common to menu items File2Decimals
  and File4Decimals, and RadioGroup RGDecimals.         }
procedure TFormMain.File2DecimalsClick(Sender: TObject);
begin
  // if a menu item was clicked, select corresponding radiobutton
  if Sender = File2Decimals then RGDecimals.ItemIndex := 0
  else
    if Sender = File4Decimals then RGDecimals.ItemIndex := 1;

  // Set / reset the checkmarks in the menu
  File2Decimals.Checked := (RGDecimals.ItemIndex = 0);
  File4Decimals.Checked := (RGDecimals.ItemIndex = 1);

  UnitsConvert;
end;

{ Event handler common to: OnClick of menu items ConvLength
  and ConvVolume, and the OnChange event of TabControl1.   }
procedure TFormMain.ConvLengthClick(Sender: TObject);
begin
  // if a menu item was clicked, select corresponding radiobutton
  if Sender = ConvLength then TabControl1.TabIndex := 0
  else
    if Sender = ConvVolume then TabControl1.TabIndex := 1;
  // Set / reset the checkmarks in the menu
  ConvLength.Checked := (TabControl1.TabIndex = 0);
  ConvVolume.Checked := (TabControl1.TabIndex = 1);
  // Empty the ListBox
  RGUnitNames.Items.Clear;
  // Fill ListBox with unit-names
  case TabControl1.TabIndex of
    0: begin
         RGUnitNames.Items.Add('mm');
         RGUnitNames.Items.Add('cm');
         RGUnitNames.Items.Add('m');
         RGUnitNames.Items.Add('km');
         RGUnitNames.Items.Add('inch');
         RGUnitNames.Items.Add('foot');
         RGUnitNames.Items.Add('yard');
         RGUnitNames.Items.Add('mile');
       end;
    1: begin
         RGUnitNames.Items.Add('cc');
         RGUnitNames.Items.Add('liter');
         RGUnitNames.Items.Add('m3');
         RGUnitNames.Items.Add('inch3');
         RGUnitNames.Items.Add('galUS');
         RGUnitNames.Items.Add('galUL');
         RGUnitNames.Items.Add('foot3');
         RGUnitNames.Items.Add('yard3');
       end;
  end;
  // Set radiogroup to base unit;
  // purely by chance, in both cases this is the third button.
  RGUnitNames.ItemIndex := 2;
  UnitsConvert;
end;

{ When the Edit has the focus, and a key is pressed:
  if it was the ENTER key, the conversion has to be executed;
  if it was the COMMA key or the POINT key, it is converted to
  the correct decimal symbol that is set in Windows.           }
procedure TFormMain.EdAmountKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then                     // ENTER was pressed
    UnitsConvert
  else
    if (Key = ',') or (Key = '.') then  // , or . was pressed
      Key := DecimalSeparator;
end;

procedure TFormMain.FileExitClick(Sender: TObject);
begin
  Close;
end;

end.
