unit euroform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TForm1 = class(TForm)
    InputEdit: TEdit;
    CurrLabel: TLabel;
    Label2: TLabel;
    EuroLabel: TLabel;
    BEFLabel: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    EuroButton: TButton;
    BEFButton: TButton;
    procedure EuroButtonClick(Sender: TObject);
    procedure BEFButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ Event handler for EuroButton: conversion from Euro to BEF.
  Shows the name of the starting currency, converts the text
  of the Edit-box to Belgian francs, shows the results.       }
procedure TForm1.EuroButtonClick(Sender: TObject);
var
  Euro, Fr: real;
  S1, S2: string;
begin
  // Show the name of the starting currency
  CurrLabel.Caption := 'Euro';

  // Convert the text of the EDIT to a numerical value
  Euro := StrToFloat(InputEdit.Text);

  // Convert from Euro to BEF
  Fr := Euro * 40.3399;

  { Convert the floating point numbers to string-format.
    '0.00' is the 'Format String', meaning:
    'format the result with 2 decimal digits to the right
     of the decimal separator'}
  S1 := FormatFloat('0.00', Euro);
  S2 := FormatFloat('0.00', Fr);

  // Put the strings in the CAPTION of the LABELs
  EuroLabel.Caption := S1;
  BEFLabel.Caption := S2;
end;

{ Event handler for BEFButton: conversion from BEF to Euro.
  Shows the name of the starting currency, converts the text
  of the Edit-box to Euro, shows the results.               }
procedure TForm1.BEFButtonClick(Sender: TObject);
var
  Euro, Fr: real;
  S1, S2: string;
begin
  // Show the name of the starting currency
  CurrLabel.Caption := 'BEF';

  // Convert the text of the EDIT to a numerical value
  Fr := StrToFloat(InputEdit.Text);

  // Convert from Euro to BEF
  Euro := Fr / 40.3399;

  { Convert the floating point numbers to string-format.
    '0.00' is the 'Format String', meaning:
    'format the result with 2 decimal digits to the right
     of the decimal separator'}
  S1 := FormatFloat('0.00', Euro);
  S2 := FormatFloat('0.00', Fr);

  // Put the strings in the CAPTION of the LABELs
  EuroLabel.Caption := S1;
  BEFLabel.Caption := S2;
end;

end.
